#include <stdio.h>
#include <stdlib.h>

struct lista {
    int sused;
    struct lista *rep;
};

#define novi(x) x=(struct lista *)malloc(sizeof(struct lista))
#define NILL (-1)
#define CRNI 1
#define BELI 0

void dodaj_p(struct lista **p, int k) {
    struct lista *temp;
    novi(temp);
    temp->sused = k;
    temp->rep = *p;
    *p = temp;
}

int pronadji(struct lista *p, int v) {
    while (p) {
        if (p->sused==v) return 1;
        p = p->rep;
    }
    return 0;
}

void enqueue(int *poc, int *kraj, int i, int *red, int n) {
    int p = *poc; int k = *kraj;
    k = k+1;
    red[k] = i;
    *poc = p; *kraj = k;
}

int dequeue(int *poc, int *kraj, int *red, int n) {
    int p = *poc; int k = *kraj;
    int cvor;
    if (k<p) return NILL;
    cvor = red[p];
    p = p+1;
    *poc = p; *kraj = k;
    return cvor;
}

int bfs(int s, int *red, int *d, int *boja, struct lista **graf, int n) {
    int moze = 1;
    int poc = 0, kraj = -1;
    d[s] = 0;
    boja[s] = 0;
    enqueue(&poc, &kraj, s, red, n);
    int i, j;

    while((i=dequeue(&poc, &kraj, red, n))!=NILL) {
        struct lista *pom = graf[i];
        while (pom) {
            j = pom->sused;
            if (d[j]==NILL) {
                d[j]=d[i]+1;
                boja[j] = d[j]%2;
                enqueue(&poc, &kraj, j, red, n);
            }
            else {
                if (boja[i]==boja[j]) {
                    moze = 0;
                    return moze;
                }
            }
            pom = pom->rep;
        }
	}
	return moze;
}

int main()
{
    int n, m, i, u, v, moze=1, n1, n2;
    int *d, *red, *boja, *pokrivac1, *pokrivac2;
    struct lista **graf;
    scanf("%d%d",&n,&m);
    graf = (struct lista **)malloc((n+1)*sizeof(struct lista *));
    d = (int *)malloc((n+1)*sizeof(int));
    red = (int *)malloc(n*sizeof(int));
    boja = (int *)malloc((n+1)*sizeof(int));
    pokrivac1 = (int *)malloc((n+1)*sizeof(int));
    pokrivac2 = (int *)malloc((n+1)*sizeof(int));

    for (i=0; i<=n; i++) {
        graf[i] = NULL;
        d[i] = boja[i] = NILL;
    }

    for (i=0; i<m; i++) {
        scanf("%d%d", &u, &v);
        dodaj_p(&graf[u], v);
        dodaj_p(&graf[v], u);
    }

    for (i=1; i<=n; i++) {
        if (boja[i]==NILL) {
            moze = bfs(i, red, d, boja, graf, n);
            if (!moze)
                break;
        }
    }

    if (!moze)
        printf("-1\n");
    else {
        n1=0; n2=0;
        for (i=1; i<=n; i++) {
            if (boja[i]==1) {
                pokrivac1[n1++] = i;
            }
            else {
                pokrivac2[n2++] = i;
            }
        }
        printf("%d\n",n1);
        for (i=0; i<n1; i++)
            printf("%d ",pokrivac1[i]);
        printf("\n%d\n",n2);
        for (i=0; i<n2; i++)
            printf("%d ",pokrivac2[i]);
        printf("\n");
    }


    return 0;
}
